import sys
import os
from inspect import getmembers, isfunction

folders = "graphnn, pickles, referenceMids, generatedMids, tmpmids".split(", ")
for folder in folders:
    if not os.path.exists(folder):
        os.mkdir(folder)
method = sys.argv[1] if len(sys.argv) > 1 else "z3"


python_version = "python3.6"
def performProgramSynthesis():
    os.system(python_version + " preprocessgraph.py") #get dense adjacency tensors
    os.system(python_version + " genprogram.py") #synthesize reference measures

os.system(python_version + " preprocesscorpus.py") #filter out non-4/4 / 16 bar pieces
performProgramSynthesis()
os.system(python_version + " trainProgramPredictor.py") #train program predictor

def genZ3():
    os.system(python_version + " music_vae_generate_random.py") #generate some reference measures sampled from MusicVAE
    os.system(python_version + " gensamplescaffolding.py") #generate some sample programs
    os.system(python_version + " genstrucz3.py") #generate music conditioned on sampled reference measures + programs

def genVAE():
    os.system(python_version + " gensamplerelsmagent.py") #learn the symmetry classifier for the semantic loss
    os.system(python_version + " predictrel.py")

    os.system(python_version + " genrealgraphs.py") #turn data into torch_geometric graph format
    os.system(python_version + " graphvaetrain.py") #train the Graph VAE
    os.system(python_version + " vae2gen.py") #generate Magenta Embeddings by sampling from Graph VAE
    os.system(python_version +  " music_vae_generate_reals.py") #turn embeddings into MIDI

if method.lower() == "z3":
    genZ3()
elif method.lower() == "vae":
    genVAE()
else:
    print("invalid method - use 'z3' or 'vae' as the first argument")
